function [B0, Det] = Bdet(XX,R,S)
% Computing the strain-displacement matrix and the determinant
RP = 1.0+R;
SP = 1.0+S;
RM = 1.0-R;
SM = 1.0-S;
%interpolation functions
% H(1) = 0.25*RP*SP;
% H(2) = 0.25*RM*SP;
% H(3) = 0.25*RM*SM;
%H(4) = 0.25*RP*SM;
%derivatives of interpolation functions
%1. with respect to R
P=zeros(2,4);
P(1,1) = 0.25*SP;
P(1,2) = -P(1,1);
P(1,3) = -0.25*SM;
P(1,4) = -P(1,3);
%2. with respect to S
P(2,1) = 0.25*RP;
P(2,2) = 0.25*RM;
P(2,3) = -P(2,2);
P(2,4) = -P(2,1);
%Evaluation of the Jacobian matrix
XJ  =P*XX;
% Determinant
Det = XJ(1,1)*XJ(2,2)-XJ(1,2)*XJ(2,1);
if(Det <= 0.0)
    display('ERROR: Jacobian matrix is not positive definite.');
    return;
end
%inverse of jacobian matrix
XJI=zeros(2,2);
XJI(1,1) = XJ(2,2)/Det;
XJI(1,2) = -XJ(1,2)/Det;
XJI(2,1) = -XJ(2,1)/Det;
XJI(2,2) = XJ(1,1)/Det;
%Evaluation of global derivative operator B0
j=0;
B0=zeros(3,8);
for i=1:4
    j = j+2;
    B0(1,j-1) = B0(1,j-1) + XJI(1,:)*P(:,i);
    B0(2,j)   = B0(2,j)   + XJI(2,:)*P(:,i);
    B0(3,j)   = B0(1,j-1);
    B0(3,j-1) = B0(2,j);
end